// $Id: reloadeveryOverlay.js,v 1.4 2005/11/22 20:50:57 jaap Exp $

/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is Jaap Haitsma.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * by the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Jaap Haitsma <jaap@haitsma.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// Uncomment DEBUG part and //log statements to have logging to the console
// Furthermore you need to add the following two lines to prefs.js to see
// the logging in the shell where you started the browser
// user_pref("browser.dom.window.dump.enabled", true);
// user_pref("javascript.options.showInConsole", true);

////////////////////////////////////////////////////////////////////////////
// Debug part
/////////////////////////////////////////////////////////////////////////////
/*
function //log(str){
  dump(str + "\n");
}

function logObject(obj){
  dump("\nlogging object contents\n");
  for(i in obj){
    dump(i + " = " + obj[i] + "\n");
  }
  dump("\n");
}
*/
////////////////////////////////////////////////////////////////////////////

// History:
// 2006 - Extended for World Cup 2006 usage: Ormus (http://www.tooor.de)
// 2007 - Extended for many ticketshops: MonsieuL and Ormus (http://tool.ormus.info/))
// 15.01.2008 - Added colored tabs (Ormus)

const DEFAULT_RELOAD_TIME = 10;
const DEFAULT_CUSTOM_RELOAD_TIME = 90;
const DEFAULT_RANDOMIZE = false;
const VERSION = "5.0.0.0";

var query = "";
var searchStrings = [];
var viagogoAuth = "";

var overload = false;

// prefs object for user-agent switching
var ormusTool_PreferencesService = Components.classes["@mozilla.org/preferences-service;1"].
                                    getService(Components.interfaces.nsIPrefService).getBranch("");;

// Every time a new browser window is made reloadEveryInit will be called
window.addEventListener("load",reloadEveryInit,false);


// This holds the object for accessing the preferences stored in prefs.js
var reloadEveryPrefs = Components.classes["@mozilla.org/preferences-service;1"].
                       getService(Components.interfaces.nsIPrefService).getBranch("reloadevery.");


function getCurTab(){
    return getBrowser().mCurrentBrowser;
}


var gReloadEveryDialogAccepted;

function reloadEveryDialogResult(accepted){
    //log("reloadEveryDialogResult(): accepted = " + accepted );

    gReloadEveryDialogAccepted = accepted;
}


function reloadEveryInit() {
    //log("reloadEveryInit()"); 
    var installedVersion;
    
    if (reloadEveryPrefs.prefHasUserValue("version")){
      installedVersion = reloadEveryPrefs.getCharPref("version");
    } else {
      // first install or first time with confirmation feature
      installedVersion = "";
    }
    
    if(installedVersion != VERSION){
      reloadEveryPrefs.setCharPref("version",VERSION);
      const browser = getBrowser();
      browser.selectedTab = browser.addTab("http://tool.ormus.info/index.php?/pages/done.html", null);
    }

    if (!reloadEveryPrefs.prefHasUserValue("reload_time")){
        //log("reloadEveryInit(): no preferences found in prefs.js taking default for reload_time");
        // Assign default value
        reloadEveryPrefs.setIntPref("reload_time", DEFAULT_RELOAD_TIME);
    }

    if (!reloadEveryPrefs.prefHasUserValue("custom_reload_time")){
        //log("reloadEveryInit(): no preferences found in prefs.js taking default for custom_reload_time");
        // Assign default value
        reloadEveryPrefs.setIntPref("custom_reload_time", DEFAULT_CUSTOM_RELOAD_TIME);
    }

    if (!reloadEveryPrefs.prefHasUserValue("randomize_time")){
        //log("reloadEveryInit(): no preferences found in prefs.js taking default for custom_reload_time");
        // Assign default value
        reloadEveryPrefs.setIntPref("randomize_time", DEFAULT_RANDOMIZE);
    }

    try{
	document.getElementById("contentAreaContextMenu").addEventListener("popupshowing",onReloadEveryPopup,false);
        gURLBar.addEventListener("keypress", onReloadEveryKeyPressInURLBar, false);
    }
    catch(e){
        // Do nothing. reloadEveryInit() is also called when the preferences dialog is called and there 
        // gURLBar.addEventListener("keypress", onReloadEveryKeyPressInURLBar, false);  
        // fails
    }
}


var reloadEveryTabID=0;

function setupReloadEvery(tab){
    //log("setupReloadEvery(tab)");

    // Add member attributes
    tab.reloadEveryEnabled = false;
    tab.reloadEveryReloadTime = reloadEveryPrefs.getIntPref("reload_time");
    //log("reload time: " + tab.reloadEveryReloadTime);
    tab.reloadEveryTimerID = null;
    tab.postDataAcceptedByUser = false;
    tab.id = "ActiveReloadTab" + reloadEveryTabID;   
	tab.randomize = reloadEveryPrefs.getIntPref("randomize_time");
    reloadEveryTabID++;    
    tab.currentState = -1; 
    /* supported states:
        -1 : default state
        0 : OrmusTool currently active
        1 : OrmusTool stopped by success
    */
    
    tab.reloadEveryProgressListener = reloadEveryProgressListener(tab);
}


// hide the Reload Every item when apropriate (use same logic as for Back, Stop etc.)
function onReloadEveryPopup() {

    //log("onReloadEveryPopup()");
    var cm = gContextMenu;
    document.getElementById("reloadevery_menu").hidden = ( cm.isTextSelected || cm.onLink || cm.onImage || cm.onTextInput );

    // Check if this a new window/tab   
    if (getCurTab().reloadEveryEnabled == null){
        //log("onReloadEveryPopup() new window"); 
        //this.setAttribute("ormusToolState", -1); 
        setupReloadEvery(getCurTab());    
    }

    if (getCurTab().reloadEveryEnabled){
        document.getElementById("reloadevery_enable").setAttribute("checked", "true");
    }
    else{
        document.getElementById("reloadevery_enable").setAttribute("checked", "false");
    }
    
  if (getCurTab().randomize){
        document.getElementById("reloadevery_randomize").setAttribute("checked", "true");
    }
    else{
        document.getElementById("reloadevery_randomize").setAttribute("checked", "false");
    }
    
  if (getCurTab().viagogoTarn){
        document.getElementById("reloadevery_viagogo_tarnmode").setAttribute("checked", "true");
    }
    else{
        document.getElementById("reloadevery_viagogo_tarnmode").setAttribute("checked", "false");
    }
 
    // First uncheck all radio menuitems
    document.getElementById("reloadevery_5s").setAttribute("checked", "false");
    document.getElementById("reloadevery_10s").setAttribute("checked", "false");
    document.getElementById("reloadevery_30s").setAttribute("checked", "false");
    document.getElementById("reloadevery_1m").setAttribute("checked", "false");
    document.getElementById("reloadevery_5m").setAttribute("checked", "false");
    document.getElementById("reloadevery_15m").setAttribute("checked", "false");
    document.getElementById("reloadevery_custom").setAttribute("checked", "false");

    // Now select the appropriate one
 
    if (getCurTab().reloadEveryReloadTime == 5){
        document.getElementById("reloadevery_5s").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 10){
        document.getElementById("reloadevery_10s").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 30){
        document.getElementById("reloadevery_30s").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 60){
        document.getElementById("reloadevery_1m").setAttribute("checked", "true");  
    }
    else if (getCurTab().reloadEveryReloadTime == 5*60){
        document.getElementById("reloadevery_5m").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 15*60){
        document.getElementById("reloadevery_15m").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime >= 0){
        document.getElementById("reloadevery_custom").setAttribute("checked", "true"); 
    }
    else{
        alert ("Invalid reload time:" + getCurTab().reloadEveryReloadTime + "s");
    }
}


// hide the Reload Every item when apropriate (use same logic as for Back, Stop etc.)
function onButReloadEveryPopup() {

    //log("onButReloadEveryPopup()");

    // Check if this a new window/tab   
    if (getCurTab().reloadEveryEnabled == null){
        //log("onReloadEveryPopup() new window"); 
        setupReloadEvery(getCurTab());    
    }

    if (getCurTab().reloadEveryEnabled){
        document.getElementById("but_reloadevery_enable").setAttribute("checked", "true");
    }
    else{
        document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
    }
 
	if (getCurTab().randomize){
        document.getElementById("but_reloadevery_randomize").setAttribute("checked", "true");
    }
    else{
        document.getElementById("but_reloadevery_randomize").setAttribute("checked", "false");
    }
    
  if (getCurTab().viagogoTarn){
        document.getElementById("but_reloadevery_viagogo_tarnmode").setAttribute("checked", "true");
    }
    else{
        document.getElementById("but_reloadevery_viagogo_tarnmode").setAttribute("checked", "false");
    }

    // First uncheck all radio menuitems
    document.getElementById("but_reloadevery_5s").setAttribute("checked", "false");
    document.getElementById("but_reloadevery_10s").setAttribute("checked", "false");
    document.getElementById("but_reloadevery_30s").setAttribute("checked", "false");
    document.getElementById("but_reloadevery_1m").setAttribute("checked", "false");
    document.getElementById("but_reloadevery_5m").setAttribute("checked", "false");
    document.getElementById("but_reloadevery_15m").setAttribute("checked", "false");
    document.getElementById("but_reloadevery_custom").setAttribute("checked", "false");

    // Now select the appropriate one
 	
    if (getCurTab().reloadEveryReloadTime == 5){
        document.getElementById("but_reloadevery_5s").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 10){
        document.getElementById("but_reloadevery_10s").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 30){
        document.getElementById("but_reloadevery_30s").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 60){
        document.getElementById("but_reloadevery_1m").setAttribute("checked", "true");  
    }
    else if (getCurTab().reloadEveryReloadTime == 5*60){
        document.getElementById("but_reloadevery_5m").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime == 15*60){
        document.getElementById("but_reloadevery_15m").setAttribute("checked", "true");
    }
    else if (getCurTab().reloadEveryReloadTime >= 0){
        document.getElementById("but_reloadevery_custom").setAttribute("checked", "true"); 
    }
    else{
        alert ("Invalid reload time:" + getCurTab().reloadEveryReloadTime + "s");
    }
}

// Reloads the page of the tab with the specified reloadEveryTabID 
function reloadPage(reloadEveryTabID){
    //log("reloadPage(...) : " + reloadEveryTabID);
    tab = document.getElementById(reloadEveryTabID);
    
    if (!tab.reloadEveryEnabled)
    	return;

	//Not used anymore, deletes the AkaTime cookie for the World Cup 06 Ticket Shop
	var cookiemanager = Components.classes["@mozilla.org/cookiemanager;1"].getService(); 
	cookiemanager = cookiemanager.QueryInterface(Components.interfaces.nsICookieManager); 
 
	//cookiemanager.remove("ssltickets.fifaworldcup.com", "AkaTime", "/", false); 
	//*/
	
	var newURI = null; 
	//var newReload = false;
  	
  // old sound handling, kept for reference
	//soundURL = "file:///C:/NOTIFY.WAV";
	//soundURL2 = "file:///C:/SPLASH.WAV";
	//var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
	//var url = ioService.newURI(soundURL, null, null);
	//var url2 = ioService.newURI(soundURL2, null, null);
	//gSound.play(url);

  var sfile = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
	sfile.spec = "chrome://reloadevery/content/NOTIFY.WAV";
  var sfileSec = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
	sfileSec.spec = "chrome://reloadevery/content/SPLASH.WAV";

	gSound = Components.classes["@mozilla.org/sound;1"].createInstance(Components.interfaces.nsISound);

// Viagogo: All (?) error pages
if(tab.contentDocument.URL.indexOf("viagogo")>=0) 
{
  handleViagogo(tab, gSound, sfile, cookiemanager);
}

// FC Bayern - Ticketshop
if (tab.contentDocument.URL.indexOf("tickets.fcbayern.de")>=0)
{
	newURI = handleFCB(tab, gSound, sfile, cookiemanager);
}

// Shop von Ticketonline.de: u.a. St. Pauli, K'lautern
if (tab.contentDocument.URL.indexOf("ticketonline.de")>=0)
{
	handleTicketonline(tab, gSound, sfile);
}

// mk-ticket.de: Vorverkaufsstelle fr VfB Stuttgart, KSC
if (tab.contentDocument.URL.indexOf("mk-ticket")>=0)
{
	handleMkTicket(tab, gSound, sfile);
}

// Schalke-Forum ("Ticketbrse")
if (tab.contentDocument.URL.indexOf("forum-aufschalke")>=0)
{
	handleSchalkeBoerse(tab, gSound, sfile);	
}

// Schalke-, K'lautern-, Gladbach, Frankfurt, 1860 und Rostock-Ticketshop,
if (tab.contentDocument.URL.indexOf("ts-ticketshop")>=0 || 
    tab.contentDocument.URL.indexOf("fck-ticketshop")>=0 ||
    tab.contentDocument.URL.indexOf("borussia-ticketing")>=0 || 
    tab.contentDocument.URL.indexOf("tsv1860-ticketing")>=0 ||
//    tab.contentDocument.URL.indexOf("ticket.eintracht.de")>=0 ||
    tab.contentDocument.URL.indexOf("hansa-ticketshop.de")>=0)
{
	newURI = handleTs(tab, gSound, sfile, cookiemanager);
}

// Ticketshop von Eintracht Frankfurt
if (tab.contentDocument.URL.indexOf("eintracht.de/tickets")>=0)
{
	handleFrankfurt(tab, gSound, sfile);
}

// Ticketshop der FA: berprfe auf Links innerhalb der Event-Tabelle
if (tab.contentDocument.URL.indexOf("thefa")>=0)
{
	handleFA(tab, gSound, sfile);
}

// Werder-Tauschbrse: Suche nach angegebenen Spielen
if (tab.contentDocument.URL.indexOf("werder")>=0 &&
    tab.contentDocument.URL.indexOf("kartenboerse")>=0)
{
	handleWerderBoerse(tab, gSound, sfile);
}
// Werder Onlineshop
else if (tab.contentDocument.URL.indexOf("werder")>=0 && tab.contentDocument.URL.indexOf("shop")>=0)
{
	handleWerder(tab, gSound, sfile);
}


// EventimSports: Shops von diversen Fuvallvereinen (Dortmund, Bielefeld, etc)
if(tab.contentDocument.URL.indexOf("eventimsports")>=0)
{
	handleEventimsports(tab, gSound, sfile);	
	//newReload = true;
}
// Eventim: All (?) ticket pages
else if(tab.contentDocument.URL.indexOf("eventim")>=0) 
{
  handleEventim(tab, gSound, sfile);
}

// Energie Cottbus Onlineticket-Shop (falls wider Erwarten doch mal jemand hin will ;) )
if (tab.contentDocument.URL.indexOf("etix.com")>=0)
{
	handleCottbus(tab, gSound, sfile);
}

// VfL Wolfsburg  Onlineticket-Shop
// fix: new URL
if (tab.contentDocument.URL.indexOf("onlineticket-vfl-wolfsburg")>=0 ||
    tab.contentDocument.URL.indexOf("onlineticketverkauf.de")>=0)
{
	handleWolfsburg(tab, gSound, sfile);
}

// Hansa Rostock Onlineticket-Shop (alter Shop)
if (tab.contentDocument.URL.indexOf("fc-hansa.onlinex")>=0)
{
	handleRostock(tab, gSound, sfile);
}

// ticketcorner.com (Schweiz)
if (tab.contentDocument.URL.indexOf("ticketcorner")>=0)
{
	handleTicketcorner(tab, gSound, sfile);
}

// SC Freiburg und Offenbach - Ticketshop
if (tab.contentDocument.URL.indexOf("scfreiburg")>=0 || 
		tab.contentDocument.URL.indexOf("reservix.de")>=0)
{
	handleFreiburg(tab, gSound, sfile);
}

// BVB Vorverkaufsstelle Rupprecht bzw. Ringsdorf
if (tab.contentDocument.URL.indexOf("kartenvorverkauf-rupprecht")>=0 ||
		tab.contentDocument.URL.indexOf("vorverkaufsstelle-ringsdorf")>=0)
{
	handleRupprecht(tab, gSound, sfile);
}

// BVB Vorverkaufsstelle Krause 
if (tab.contentDocument.URL.indexOf("kartenvorverkauf-krause")>=0) 
{
	handleKrause(tab, gSound, sfile);
}

// Chelsea Onlineshop (Warteraum)
if (tab.contentDocument.URL.indexOf("agency=CHELSEA_MYTIXX")>=0) 
{
	handleChelsea(tab, gSound, sfile);
}

// Frankreich EM 2008 FCFS - Ticketshop
if (tab.contentDocument.URL.indexOf("billets2008-fff.francebillet.com")>=0) 
{
	handleFrance08(tab, gSound, sfile);
}

// World Cup 2006 handling, kept for sentimental reasons
if(tab.contentDocument.URL.indexOf("fifaworldcup")>=0) 
{
  handleWM2006(tab, gSound, sfile, sfileSec);
}

// Italien EM 2008 FCFS - Ticketshop
if (tab.contentDocument.URL.indexOf("www.ticketone.it")>=0) 
{
	handleItaly08(tab, gSound, sfile);
}

// for testing purposes (special test website will be created)
if(tab.contentDocument.URL.indexOf("test.ormus.info")>=0) 
{
  if(tab.contentDocument.getElementById("ormustooltest") != null)
  {
    if(tab.reloadEveryEnabled) 
    {
//      tab.reloadEveryEnabled = false;
//      tab.currentState = 1;      
//      colorTab(tab);
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
			ticketsFound(tab, gSound, sfile, false);
    	//alert('Test end');
    }                         
  }
}

    if (tab == null){
        //log("reloadPage(...) : ReloadEvery disabled");
        return;
    }

    if (tab.reloadEveryEnabled == false){
        tab.postDataAcceptedByUser = false;
        //log("reloadPage(...) : ReloadEvery disabled");
        return;
    }

    //log("reloadPage(...) : " + reloadEveryTabID + "reloading url :" + tab.webNavigation.currentURI.spec);
    var loadFlags = nsIWebNavigation.LOAD_FLAGS_BYPASS_HISTORY | nsIWebNavigation.LOAD_FLAGS_BYPASS_PROXY | nsIWebNavigation.LOAD_FLAGS_BYPASS_CACHE;
    var entry=tab.webNavigation.sessionHistory.getEntryAtIndex(tab.webNavigation.sessionHistory.index, false);
    var postData = entry.QueryInterface(Components.interfaces.nsISHEntry).postData;
    var referrer = entry.QueryInterface(Components.interfaces.nsISHEntry).referrerURI;
	
    if ((postData!=null) && (tab.postDataAcceptedByUser==false)){
        window.openDialog("chrome://reloadevery/content/warnPostData.xul", "",
                          "chrome,centerscreen,modal", reloadEveryDialogResult);
        if (gReloadEveryDialogAccepted){
            //log("reloadPage(...) : POSTDATA accepted");
            tab.postDataAcceptedByUser = true;
        }
        else{
            //log("reloadPage(...) : POSTDATA not accepted");
            tab.reloadEveryEnabled=false;
            return;           
        }        
    }                      
    tab.curScrollX = tab.contentWindow.scrollX;
    tab.curScrollY = tab.contentWindow.scrollY;
    //log("Current scroll position " + tab.curScrollX + ", "+ tab.curScrollY);

    var notifyFlags = Components.interfaces.nsIWebProgress.NOTIFY_ALL;
    tab.webProgress.addProgressListener(tab.reloadEveryProgressListener, notifyFlags);         
    
    //window.alert(newURI);
    // der Reload der Seite:
    if (newURI == null)
    {
    	//tab.webNavigation.loadURI(tab.webNavigation.currentURI.spec, loadFlags, referrer, entry.postData, null);     
			tab.webNavigation.reload(loadFlags);
    }
  	else {
  		tab.webNavigation.loadURI(newURI, loadFlags, referrer, entry.postData, null);  
  	}
    
    

	// deletes the cookie of the World Cup 2006 ticket shop, not needed anymore
	//cookiemanager.remove("ssltickets.fifaworldcup.com", "AkaTime", "/", false); 
	
	// change interval if randomize is activated
	if (tab.reloadEveryEnabled && tab.randomize){
		setNextInterval(tab);
	}
                  
}

function enableReloadEvery(tab){
    //log("enableReloadEvery(tab)");
    tab.reloadEveryEnabled = true;
    tab.currentState = 0;
    colorTab(tab);
    clearInterval(tab.reloadEveryTimerID);
    tab.reloadEveryTimerID=setTimeout("reloadPage(\"" + tab.id + "\");", tab.reloadEveryReloadTime*1000);  
    
    // switchUserAgent();
    // causes problems with javascripts in  Firefox: disabled
    
    /*
    // If disabling external images
    webdeveloper_setIntegerPreference("network.image.imageBehavior", legacyImageBehavior);
    webdeveloper_setIntegerPreference("permissions.default.image", imageBehavior);*/
    
}

function disableReloadEvery(tab){
    //log("disableReloadEvery(tab)");
    tab.reloadEveryEnabled = false;
    tab.currentState = -1;    
    colorTab(tab);
    tab.postDataAcceptedByUser = false;
    clearInterval(tab.reloadEveryTimerID);
    query="";
    searchStrings=[];
    //tab.searchStrings = [];
    overload = false;
}

///////////////////////////////////////////////////////////////////////////////

function onReloadEveryEnable(){ 
    //log("onReloadEveryEnable()");

    if (getCurTab().reloadEveryEnabled){
        disableReloadEvery(getCurTab());
    }
    else{
        enableReloadEvery(getCurTab());    
    }
}

function onSetReloadTime(aReloadTime){
    //log ("onSetReloadTime() ReloadTime " + aReloadTime);

    getCurTab().reloadEveryReloadTime=aReloadTime;
    reloadEveryPrefs.setIntPref("reload_time", getCurTab().reloadEveryReloadTime);    
    enableReloadEvery(getCurTab());
}


function onReloadEveryCustom(){
    //log("onReloadEveryCustom()");
    
    window.openDialog("chrome://reloadevery/content/reloadeveryCustomDialog.xul", "",
                      "chrome,centerscreen,modal", reloadEveryDialogResult);
    if (gReloadEveryDialogAccepted){
       //log("onReloadEveryCustom() accepted");
        getCurTab().reloadEveryReloadTime=reloadEveryPrefs.getIntPref("custom_reload_time");         
        enableReloadEvery(getCurTab());

    }
}

function reloadeveryCustomDialogLoadSettings(){
    //log("reloadeveryCustomDialogLoadSettings()");

    var customReloadTime = reloadEveryPrefs.getIntPref("custom_reload_time");

    document.getElementById("reload_every_minutes").value = Math.floor(customReloadTime / 60);
    document.getElementById("reload_every_seconds").value = customReloadTime % 60;

}

function reloadeveryCustomDialogSaveSettings(){
    //log("reloadeveryCustomDialogSaveSettings()");
 
    var minutes;
    if(document.getElementById("reload_every_minutes").value != ''){
      minutes = parseInt(document.getElementById("reload_every_minutes").value);
    }
    else{
      minutes = 0;
    }

    var seconds;
    if(document.getElementById("reload_every_seconds").value != ''){
      seconds = parseInt(document.getElementById("reload_every_seconds").value);
    }
    else{
      seconds = 0;
    }

    var customReloadTime = minutes*60 + seconds;
    reloadEveryPrefs.setIntPref("custom_reload_time", customReloadTime);
    reloadEveryPrefs.setIntPref("reload_time", customReloadTime);
    
    return true;
}


function onReloadEveryEnableAllTabs(){ 
    //log("onReloadEveryEnableAllTabs()");
    
    nTabs=getBrowser().browsers.length;

    for(var i=0; i<nTabs; i++){
       var tab = getBrowser().browsers[i];

       if (tab.reloadEveryEnabled == null){
            setupReloadEvery(tab);
       }
       
       if (tab.reloadEveryEnabled != true){
            enableReloadEvery(tab);
       }       
    }
}


function onReloadEveryDisableAllTabs(){ 
    //log("onReloadEveryDisableAllTabs()");
    
    nTabs=getBrowser().browsers.length;

    for(var i=0; i<nTabs; i++){
       var tab = getBrowser().browsers[i];
       
       if (tab.reloadEveryEnabled == true){
            disableReloadEvery(tab);
       }       
    }
}

///////////////////////////////////////////////////////////////////////////////

// If user changes URL disable reloadevery
function onReloadEveryKeyPressInURLBar(){
    if (getCurTab().reloadEveryEnabled){
        //log("onReloadEveryKeyPressInURLBar(): disabling reload every");
        getCurTab().reloadEveryEnabled = false;
        getCurTab().postDataAcceptedByUser = false;
        clearInterval(getCurTab().reloadEveryTimerID);
    }
}


function reloadEveryProgressListener(tab){
    return ({

    QueryInterface : function(aIID){        
		if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
		    aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
			aIID.equals(Components.interfaces.nsISupports)){
			return this;
        }
		throw Components.results.NS_NOINTERFACE;
	},    
    onProgressChange : function (aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress,
                                 aCurTotalProgress, aMaxTotalProgress){
    },

    onStateChange : function(aWebProgress, aRequest, aStateFlags, aStatus){
        if ((aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_IS_WINDOW) && (aStateFlags &
        Components.interfaces.nsIWebProgressListener.STATE_STOP)){        
            //log("reloadEveryProgressListener(): page loaded " + tab.id);
            tab.webProgress.removeProgressListener(tab.reloadEveryProgressListener);
            //log("scroll to " + tab.curScrollX + "," + tab.curScrollY);
	    tab.contentWindow.scrollTo(tab.curScrollX, tab.curScrollY); 
            tab.reloadEveryTimerID=setTimeout("reloadPage(\"" + tab.id + "\");", tab.reloadEveryReloadTime*1000);
        }
    },

    onLocationChange : function(aWebProgress, aRequest, aLocation){
      //alert('event fired!');
		 /* var doc = aWebProgress.DOMWindow.document;
		  var mytab = gBrowser.mTabs[gBrowser.getBrowserIndexForDocument(doc)];
		  //var testattr = tab.getAttribute("ormusToolState");
		  //alert(mytab); 
      //alert(tab.id);
  		var nodes = document.getAnonymousNodes (mytab);
  		//alert(nodes);
  		var i = 0;
  		for (i = nodes.length - 1; i >= 0; i--) {
		    if(tab.currentState == 0) { 
			     nodes[i].style.setProperty ('background-color', 'rgb(255, 255, 51)', '');
			     }
			  if(tab.currentState == 1) { 
			     nodes[i].style.setProperty ('background-color', 'rgb(0, 255, 51)', '');
			     }
      }   */
      //tab.currentState = -1 * (tab.currentState - 1);
    },

    onStatusChange : function(aWebProgress, aRequest, aStatus, aMessage){
    },

    onSecurityChange : function(aWebProgress, aRequest, aState){
    }
    });		
}

// OrmusTool functions

function showHelp()
{
	const browser = getBrowser();
	browser.selectedTab = browser.addTab("http://tool.ormus.info/index.php?/pages/help.html", null);
}

function setNextInterval(tab){
	clearInterval(tab.reloadEveryTimerID);
	// 30% offset are possible (postive or negative)
	// 5% have up to 100% 'bad' offset
	// 5% have up to 500% 'bad' offset
	var factorOffset = Math.random()*0.3;
	var signOffset = 1;
	
	// offset positive or negative?
	if (Math.random() < 0.5) {
		signOffset = -1*signOffset;
	}

	// include some way longer intervals
	if (Math.random() <= 0.05) {
		factorOffset = Math.random();
		signOffset = 1;
	} else if (Math.random() <= 0.05) {
		factorOffset = Math.random()*5;
		signOffset = 1;
	}
	
	// calculate the interval
	var nextInterval = tab.reloadEveryReloadTime*1000 + tab.reloadEveryReloadTime*1000*signOffset*factorOffset;
	
	tab.reloadEveryTimerID=setTimeout("reloadPage(\"" + tab.id + "\");", nextInterval);
}

function onReloadEveryRandomize(){
    getCurTab().randomize = !getCurTab().randomize;
}

function onReloadEveryTarnMode()
{
	getCurTab().viagogoTarn = !getCurTab().viagogoTarn;
}

// Transforms the viagogo shop link
function transformViagogoLink(vLink){
	vLinkString = new String(vLink);
	vLinkString = vLinkString.replace(/PreBuyTickets.aspx/, "secure/BuyTickets.aspx");
  //vLinkString = vLinkString.replace(/http:/, "https:");
  vLinkString = vLinkString.replace("http://anonymouse.org/cgi-bin/anon-www_de.cgi/http", "http");
	return vLinkString;
}

// Disabled in current version: causes problems with javascripts in Firefox
// Sets a string preference
function switchUserAgent(){
// just to be sure ;-)
return;

//alert("switchUserAgent");
  // randomize platform as well?

  var supportsStringInterface = Components.interfaces.nsISupportsString;
  var string                  = Components.classes["@mozilla.org/supports-string;1"].createInstance(supportsStringInterface);

  if (Math.random() < 0.5) {
//alert("IE");
    // pretend to be an Internet Explorer
    
    string.data = decodeURIComponent("Microsoft Internet Explorer");
    ormusTool_PreferencesService.setComplexValue("general.appname.override", supportsStringInterface, string);
    string.data = decodeURIComponent("4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
    ormusTool_PreferencesService.setComplexValue("general.appversion.override", supportsStringInterface, string);
    string.data = decodeURIComponent("Win32");
    ormusTool_PreferencesService.setComplexValue("general.platform.override", supportsStringInterface, string);
    string.data = decodeURIComponent("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
    ormusTool_PreferencesService.setComplexValue("general.useragent.override", supportsStringInterface, string);
    string.data = decodeURIComponent("");
    ormusTool_PreferencesService.setComplexValue("general.useragent.vendor", supportsStringInterface, string);
    string.data = decodeURIComponent("");
    ormusTool_PreferencesService.setComplexValue("general.useragent.vendorSub", supportsStringInterface, string);
    
    /*useragentswitcher_setStringPreference("useragentswitcher.1.appname", "Microsoft Internet Explorer");
    useragentswitcher_setStringPreference("useragentswitcher.1.appversion", "4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
    useragentswitcher_setStringPreference("useragentswitcher.1.description", stringBundle.getString("useragentswitcher_userAgentInternetExplorer"));
    useragentswitcher_setStringPreference("useragentswitcher.1.platform", "Win32");
    useragentswitcher_setStringPreference("useragentswitcher.1.useragent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
    useragentswitcher_setStringPreference("useragentswitcher.1.vendor", "");
    useragentswitcher_setStringPreference("useragentswitcher.1.vendorsub", "");

    ormusTool_PreferencesService.setComplexValue(preference, supportsStringInterface, string);
  
    string.data = value;
    useragentswitcher_setStringPreference("general.appname.override", decodeURIComponent(appName));
    useragentswitcher_setStringPreference("general.appversion.override", decodeURIComponent(appVersion));
    useragentswitcher_setStringPreference("general.platform.override", decodeURIComponent(platform));
    useragentswitcher_setStringPreference("general.useragent.override", decodeURIComponent(userAgent));
    useragentswitcher_setStringPreference("general.useragent.vendor", decodeURIComponent(vendor));
    useragentswitcher_setStringPreference("general.useragent.vendorSub", decodeURIComponent(vendorSub));*/
  } else {
//alert("Firefox");
    // set user-agent to default Firefox
    if(ormusTool_PreferencesService.prefHasUserValue("general.appname.override"))
    {
      ormusTool_PreferencesService.clearUserPref("general.appname.override");
    }
    // If an override app version is set
    if(ormusTool_PreferencesService.prefHasUserValue("general.appversion.override"))
    {
      ormusTool_PreferencesService.clearUserPref("general.appversion.override");
    }
    // If an override platform is set
    if(ormusTool_PreferencesService.prefHasUserValue("general.platform.override"))
    {
      ormusTool_PreferencesService.clearUserPref("general.platform.override");
    }
    // If an override user agent is set
    if(ormusTool_PreferencesService.prefHasUserValue("general.useragent.override"))
    {
      ormusTool_PreferencesService.clearUserPref("general.useragent.override");
    }
    // If an override vendor is set
    if(ormusTool_PreferencesService.prefHasUserValue("general.useragent.vendor"))
    {
      ormusTool_PreferencesService.clearUserPref("general.useragent.vendor");
    }
    // If an override vendor sub is set
    if(ormusTool_PreferencesService.prefHasUserValue("general.useragent.vendorSub"))
    {
      ormusTool_PreferencesService.clearUserPref("general.useragent.vendorSub");
    }
  }
}

function deleteTsCookie(domain, nameindex)
{
	var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"]
                        .getService(Components.interfaces.nsICookieManager);
	cookieManager = cookieManager.QueryInterface(Components.interfaces.nsICookieManager); 
	
  	var iter = cookieManager.enumerator;
  	while (iter.hasMoreElements())
  	{
    	var cookie = iter.getNext();
    	if (cookie instanceof Components.interfaces.nsICookie)
    	{
      		//if (cookie.host.indexOf("ts-ticketshop")>=0 && cookie.path=="/") 
      		if (cookie.host.indexOf(domain)>=0 && cookie.path=="/" && cookie.name.indexOf("ASPSESSION")>=nameindex) 
      		{
        		//cookieManager.remove("www.ts-ticketshop.de", cookie.name, "/", false);
        		cookieManager.remove(domain, cookie.name, "/", false);
        		if (nameindex>=0)
        			break;
        	}
    	}
  	}
}

//function readCookie(name, document) 
//{ 
//    var cookieValue = ""; 
//    var search = name + "="; 
//    if(document.cookie.length > 0) {  
//        offset = document.cookie.indexOf(search); 
//        if(offset != -1) {  
//            offset += search.length; 
//            end = document.cookie.indexOf(";", offset); 
//            if(end == -1) end = document.cookie.length; 
//            cookieValue = unescape(document.cookie.substring(offset, end)) 
//        } 
//    } 
//    return cookieValue; 
//}

function readCookie(name, domain, document)
{
	// alte, schnellere Methode zum Lesen
	if (navigator.productSub < 20070713)
	{
		var cookieValue = ""; 
    	var search = name + "="; 
    	if(document.cookie.length > 0) {  
        	offset = document.cookie.indexOf(search); 
        	if(offset != -1) {  
            	offset += search.length; 
            	end = document.cookie.indexOf(";", offset); 
            	if(end == -1) end = document.cookie.length; 
            	cookieValue = unescape(document.cookie.substring(offset, end)) 
        	} 
    	}
    	return cookieValue; 
	}
	
	// neue, langsamere Methode, wird nur bei neueren FF-Versionen verwendet
	var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"]
                        .getService(Components.interfaces.nsICookieManager);
	cookieManager = cookieManager.QueryInterface(Components.interfaces.nsICookieManager); 
	
  	var iter = cookieManager.enumerator;
  	while (iter.hasMoreElements())
  	{
    	var cookie = iter.getNext();
    	if (cookie instanceof Components.interfaces.nsICookie)
    	{
      		//if (cookie.host.indexOf("ts-ticketshop")>=0 && cookie.path=="/") 
      		if (cookie.host.indexOf(domain)>=0 && cookie.name.indexOf(name)>=0) 
      		{
        		//cookieManager.remove("www.ts-ticketshop.de", cookie.name, "/", false);
        		return cookie.value;
        	}
    	}
  	}
  	return "";
}

function writeCookie(name, value, path, domain, document)
{
	document.cookie = name + "="+value+";path="+path+";domain="+domain;
}

function deleteViagogoCookiesViaCookieManager(cookiemanager)
{
	cookiemanager.remove(".viagogo.de", "ASP.NET_SessionId", "/", false); 
	cookiemanager.remove(".viagogo.de", ".ASPXAUTH", "/", false); 
	cookiemanager.remove(".viagogo.de", "ViagogoSession", "/", false); 
	cookiemanager.remove(".viagogo.de", ".ASPXANONYMOUS", "/", false);
	cookiemanager.remove(".viagogo.de", "vap2", "/", false);
	cookiemanager.remove(".viagogo.de", "vTrack", "/", false);
}

function checkForNewViagogoAuthentification(document)
{
	//var viagogoCookie = readCookie(".ASPXAUTH", document);
	var viagogoCookie = readCookie(".ASPXAUTH", "viagogo", document);
	if (viagogoCookie.length > 0 && viagogoCookie != viagogoAuth)
	{
		viagogoAuth = viagogoCookie;
	}
}

/*function deleteCookie (name, domain, path, document)
{
	var exp = new Date();
	exp.setTime (exp.getTime() - 1000);
	var cval = readCookie(name, document);
	document.cookie = name + "=" + cval + "; expires=" + exp.toGMTString() + ";path="+path+";domain="+domain;
}

function deleteAllCookies(domain, path, document)
{
	var cookies = document.cookie.split(";");
     
     var cookie;
     
     for(var i = 0; i < cookies.length; i++)
     {
          cookie = cookies[i].split("=");
          deleteCookie(cookie[0], domain, path, document);
     }
}

function deleteAllViagogoCookies(document)
{
	//deleteCookie("vTrack", ".viagogo.de", "/", document);
	deleteCookie("ASP.NET_SessionId", ".viagogo.de", "/", document);
	deleteCookie("ViagogoSession", ".viagogo.de", "/", document);
	//deleteCookie("vap2", ".viagogo.de", "/", document);
	deleteCookie(".ASPXAUTH", ".viagogo.de", "/", document);
}*/

// Shop-Handlers

function handleViagogo(tab, gSound, sfile, cookiemanager)
{
	if (viagogoAuth.length == 0)
  {
  	//viagogoAuth = readCookie(".ASPXAUTH", tab.contentDocument);  	
  	viagogoAuth = readCookie(".ASPXAUTH", "viagogo", tab.contentDocument); 
  }
  if (tab.viagogoTarn)
  {
  	//deleteTsCookie(".viagogo.de", -1);
  	//deleteCookie(".ASPXAUTH", ".viagogo.de", "/", tab.contentDocument);
  	//deleteAllCookies(".viagogo.de", "/", tab.contentDocument);
  	//deleteAllViagogoCookies(tab.contentDocument);
  	if (tab.checkNewAuthentificationNextTime)
  	{
  		checkForNewViagogoAuthentification(tab.contentDocument);
  		tab.checkNewAuthentificationNextTime = false;
  	}
  	if (!tab.lastLoginTime || ((new Date()).getTime()-tab.lastLoginTime > 840000))
  	{
  		checkForNewViagogoAuthentification(tab.contentDocument);
  		writeCookie(".ASPXAUTH", viagogoAuth, "/", "viagogo.de", tab.contentDocument);
  		tab.lastLoginTime = (new Date()).getTime();
  		tab.checkNewAuthentificationNextTime = true;
  	}
    else
    {
    	deleteViagogoCookiesViaCookieManager(cookiemanager);
    }
  }
  else
  {
  	//var authentification = viagogoAuth.split(";");
  	writeCookie(".ASPXAUTH", viagogoAuth, "/", "viagogo.de", tab.contentDocument);
  }
  
  //if(tab.contentDocument.getElementById("ctl00_centerContent_gridViewTicketListings") != null)
  if(tab.contentDocument.getElementById("ctl00_centerContent_gridViewTicketListings_ctl02_buyLink") != null &&
		 ( tab.contentDocument.getElementById("ctl00_centerContent_gridViewTicketListings_ctl02_buyLink").innerHTML.indexOf("Kaufen")>=0 ||
		   tab.contentDocument.getElementById("ctl00_centerContent_gridViewTicketListings_ctl02_buyLink").innerHTML.indexOf("Buy")>=0 ))
  {
  	if (tab.viagogoTarn && viagogoAuth.length > 0)
  	{
  		//var authentification = viagogoAuth.split(";");
  		writeCookie(".ASPXAUTH", viagogoAuth, "/", "viagogo.de", tab.contentDocument);
  	}
  	
//  	tab.reloadEveryEnabled = false;
//  	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//   	gSound.play(sfile);
		ticketsFound(tab, gSound, sfile, false);
		
  	// Erweiterung von mrmicman2000 (adjusted by MonsieurL)
   	window.open(transformViagogoLink(tab.contentDocument.getElementById("ctl00_centerContent_gridViewTicketListings_ctl02_sectionLink")), "_blank");
  }
  
  if (String(tab.contentDocument.URL).toLowerCase().indexOf("tarpit.htm")>=0)
  {
  	disableReloadEvery(tab);
  	window.setTimeout("enableReloadEvery(tab)", 61000);
  	
  }
}

function handleFCB(tab, gSound, sfile, cookiemanager)
{
	var newURI;
	// falls der Shop offline ist, lade die Startseite des Shops neu
	if (tab.contentDocument.URL.indexOf("offline")>=0)
	{
		//newURI = "http://tickets.fcbayern.de/internetverkauf/start.aspx";
		newURI = "http://tickets.fcbayern.de/internetverkauf";
		cookiemanager.remove("tickets.fcbayern.de", "ASP.NET_SessionId", "/", false);
		overload = true; 
	}
	else {

	// falls der Shop zuvor berlastet oder geschlossen war...
	if (overload)
	{
		overload = false;
		//tab.reloadEveryEnabled = false;
  	//document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
   	//gSound.play(sfile);
   	ticketsFound(tab, gSound, sfile, false);
   	
   	return;
	}
	
	// Blockauswahl (eingeloggt!!)
	if (tab.contentDocument.getElementById("ArenaPriceTableBlocks1_Label3") != null)
	{
		var imgs = tab.contentDocument.getElementsByTagName("img");
		var countArrows = 0;
		for (var i = 0; i < imgs.length; ++i)
		{
			if (imgs[i].src.indexOf("pics/pfeil.gif")>=0)
			{
				countArrows ++;
			}
		}
	
		if (countArrows > 5)
		{
//			tab.reloadEveryEnabled = false;
//  		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//   		gSound.play(sfile);
		ticketsFound(tab, gSound, sfile, false);
		
   		//query = "";
		}
	}
	// Spielauswahl
	else
	{
	
		if (searchStrings.length == 0)
		{
			var searchLength = 0;
			while (!(searchLength>0))
			{
				searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
			}
			for (var i = 0; i < searchLength; ++i)
			{
				searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
			}
		}
	
		var tds = tab.contentDocument.getElementsByTagName("td");
		var breakflag = false;
		for (var i = 0; i < tds.length; ++i)
		{
			if (tds[i].innerHTML.length < 60 && tds[i].parentNode != null &&
			    tds[i].parentNode.innerHTML != null && 
			    (tds[i].parentNode.innerHTML.indexOf("pics/pfeil.gif")>=0 ||
			    tds[i].parentNode.innerHTML.indexOf("pics/cred.gif")>=0))
			{
				for (var j = 0; j < searchStrings.length; ++j)
				{
					if (tds[i].innerHTML.toLowerCase().indexOf(searchStrings[j].toLowerCase())>=0)
					{
//						tab.reloadEveryEnabled = false;
//  					document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//   					gSound.play(sfile);
//   					searchStrings = [];
						ticketsFound(tab, gSound, sfile, true);
   					breakflag = true;
   					break;
					}
				}
				if (breakflag) 
					break;
			}
		}
		
		if (!breakflag)
		{
			newURI = "http://tickets.fcbayern.de/internetverkauf/start.aspx";
			cookiemanager.remove("tickets.fcbayern.de", "ASP.NET_SessionId", "/", false);
		}
	}
	}
	
	return newURI;
}

function handleTicketonline(tab, gSound, sfile)
{
	var opts = tab.contentDocument.getElementsByTagName("option");
	for (var i = 0; i < opts.length; ++i)
	{
		if (opts[i].value == 1)
		{
//      tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
    	ticketsFound(tab, gSound, sfile, false);
    	
    	break;
		}
	}
}

// berarbeitet nach Re-Design des Shops
function handleMkTicket(tab, gSound, sfile)
{
	// Bestimme Haupt-Frame
	var frames = tab.contentDocument.getElementsByTagName("frame");
	var mainframe = tab;
	for (var i = 0; i < frames.length; ++i)
	{
		if (frames[i].name.indexOf("main")>=0)
		{
			if (frames[i].name == "ek_main")
			{
				mainframe = frames[i];
				break;
			}
			else
			{
				var subFrames = frames[i].contentDocument.getElementsByTagName("frame");
				for (var j = 0; j < subFrames.length; ++j)
				{
					if (subFrames[j].name == "ek_main")
					{
						mainframe = subFrames[j];
						break;
					}
				}	
				break;	
			}
		}
	}
	if (mainframe != null)
	{
		// Suche im Haupt-Frame nach Input-Elementen fr Mengenangabe
		var inputs = mainframe.contentDocument.getElementsByTagName("input");
		for (var i = 0; i < inputs.length; ++i)
		{
			if (inputs[i].type == "text" && inputs[i].name.indexOf("menge")>=0)
			{
//      	tab.reloadEveryEnabled = false;
//    		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    		gSound.play(sfile);
				ticketsFound(tab, gSound, sfile, false);
				
    		break;
			}
		}
	}
}

function handleSchalkeBoerse(tab, gSound, sfile)
{
	if (searchStrings.length == 0)
	{
		var searchLength = 0;
		while (!(searchLength>0))
		{
			searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
		}
		for (var i = 0; i < searchLength; ++i)
		{
			searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
		}
	}
	
	var anchors = tab.contentDocument.getElementsByTagName("a");
	for (var i = 0; i < anchors.length; ++i)
	{
		if (anchors[i].href.indexOf("threadid=")>=0)
		{
			var breakFlag = false;
			for (var j = 0; j < searchStrings.length; ++j)
			{
				if (anchors[i].innerHTML.toLowerCase().indexOf(searchStrings[j].toLowerCase())>=0)
				{
//					tab.reloadEveryEnabled = false;
//    			document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    			gSound.play(sfile);
//					searchStrings=[];
    			ticketsFound(tab, gSound, sfile, true);
    			
    			window.alert(anchors[i].innerHTML);
    			breakFlag = true;
    			break;
				}
			}
			if (breakFlag)
				break;
		}
	}
}

function handleTs(tab, gSound, sfile, cookiemanager)
{
	var newURI;
	// Stelle fest, ob berlast vorliegt
	var fonts = tab.contentDocument.getElementsByTagName("font");
	var preOverload = false;
	for (var i = 0; i < fonts.length; ++i)
	{
		if (fonts[i].innerHTML.indexOf("Commerce.AuthManager")>=0)
		{
			preOverload = true;
			break;
		}
	}
	var new_overload = preOverload || tab.contentDocument.getElementById("errorTitle") != null ||
	                   tab.contentDocument.URL.indexOf("error")>=0 ;                 
	
	// Falls jetzt berlast vorliegt
	if (new_overload)
	{
		// Setze newURI, um die Hauptseite des entsprechenden Shops zu laden
		if (tab.contentDocument.URL.indexOf("ts-ticketshop")>=0)
			newURI = "www.ts-ticketshop.de";
		if (tab.contentDocument.URL.indexOf("fck-ticketshop")>=0)
			newURI = "www.fck-ticketshop.de";
		if (tab.contentDocument.URL.indexOf("borussia-ticketing")>=0)
			newURI = "www.borussia-ticketing.de";
		if (tab.contentDocument.URL.indexOf("ticket.eintracht.de")>=0)
			newURI = "ticket.eintracht.de";
		if (tab.contentDocument.URL.indexOf("hansa-ticketshop")>=0)
			newURI = "www.hansa-ticketshop.de";
		if (tab.contentDocument.URL.indexOf("tsv1860-ticketing")>=0)
			newURI = "www.tsv1860-ticketing.de";
			
		// Lsche Session-Cookie
		deleteTsCookie(newURI, 0);
		
		// Setze das overload-flag fr den nchsten Durchlauf
		overload = true;
	}
	// Falls jetzt keine berlast vorliegt ...
	else
	{
		// .. aber vorher berlast vorlag
		if (overload)
		{
			// stoppe
//			tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
			ticketsFound(tab, gSound, sfile, false);
		}
		// ... und auch zuvor keine berlast vorlag
	  else
	  {
	  	// dann suchen wir nach aktivierten Links ...
	  	
	  	// ... indem wir zuerst den Benutzer fragen, nach was gesucht werden soll
	  	if (searchStrings.length == 0)
			{
				var searchLength = 0;
				while (!(searchLength>0))
				{
					searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
				}
				for (var i = 0; i < searchLength; ++i)
				{
					searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
				}
			}
	
			// und dann alle Links nach den angegebenen Suchbegriffen durchsuchen
			var mainFrame = tab.contentDocument.getElementsByName("Main")[0];
			if (mainFrame == null)
				mainFrame = tab;
			var linkList = mainFrame.contentDocument.getElementsByTagName("a");
			for (var i = 0; i < linkList.length; ++i)
			{
  			var breakflag = false;
  			for (var j = 0; j < searchStrings.length; ++j)
  			{
  				if (String(linkList[i].text).toUpperCase().indexOf(searchStrings[j].toUpperCase())>=0)
  				{
//  					tab.reloadEveryEnabled = false;
//    				document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    				gSound.play(sfile);
//						searchStrings=[];
    				ticketsFound(tab, gSound, sfile, true);
    				
    				breakflag = true;
    				break;
  				}
  				if (breakflag)
  					break;
  			}
			}
	  }
	}
	return newURI;
}

function handleFA(tab, gSound, sfile)
{
	while (query.length == 0)
	{
		query = window.prompt("Bitte gew" + String.fromCharCode(252)+ "nschtes Spiel eingeben");
	}
	
	var table = tab.contentDocument.getElementById("dlEvents");
	if (table != null && table.getElementsByTagName("a")[0] != null)
	{
		for (var i = 0; i < table.getElementsByTagName("a").length; i+=3)
		{
			if (String(table.getElementsByTagName("a")[i].innerHTML).toLowerCase().indexOf(query.toLowerCase())>=0 &&
			    table.getElementsByTagName("a")[i].href != "")
			{
//				tab.reloadEveryEnabled = false;
//				document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    		gSound.play(sfile);
    		ticketsFound(tab, gSound, sfile, false);
    		
    		query="";
    		break;
			}
		}
	}
}

function handleWerderBoerse(tab, gSound, sfile)
{
	if (searchStrings.length == 0)
	{
		var searchLength = 0;
		while (!(searchLength>0))
		{
			searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
		}
		for (var i = 0; i < searchLength; ++i)
		{
			searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
		}
	}
		
		
		var table = tab.contentDocument.getElementsByTagName("table")[20];
		var tableElements = table.getElementsByTagName("td");
		
			for (var i = 0; i < tableElements.length; i+=3)
			{
				for (var j = 0; j < searchStrings.length; ++j) 
				{
					if (String(tableElements[i].innerHTML).toLowerCase().indexOf(String(searchStrings[j]).toLowerCase())>=0)
					{
//						tab.reloadEveryEnabled = false;
//						document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    				gSound.play(sfile);
//    				searchStrings = [];
    				ticketsFound(tab, gSound, sfile, true);
    				
    				break;
					}
				}
			}
}

function handleWerder(tab, gSound, sfile)
{
	var imgs = tab.contentDocument.getElementsByTagName("img");
	var unterseite = 0;
	for (var i = 0; i < imgs.length; ++i)
	{
		if (imgs[i].alt == "Sie befinden sich bei Schritt 1" || imgs[i].src.indexOf("zeiger_aktiv1")>=0)
		{
			unterseite = 1;
			break;
		}
		if (imgs[i].alt == "Sie befinden sich bei Schritt 2" || imgs[i].src.indexOf("zeiger_aktiv2")>=0)
		{
			unterseite = 2;
			break;
		}
	}
	
	// bersichtsseite
	if (unterseite == 1)
	{
		var anchors = tab.contentDocument.getElementsByTagName("a");
		for (var i = anchors.length - 1; i >= 0; --i)
		{
			var anchor = anchors[i];
			var attr = anchor.attributes;
			for (var j = 0; j < attr.length; ++j)
			{
				if (attr[j].name == "onclick" && attr[j].value.indexOf("spiel_id=")>=0)
				{
//					tab.reloadEveryEnabled = false;
//    			document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    			gSound.play(sfile);
    			ticketsFound(tab, gSound, sfile, false);
    			
    			break;
				}
			}
		}
	}
	// Blockauswahl
	else if (unterseite == 2)
	{
		var anchors = tab.contentDocument.getElementsByTagName("a");
		for (var i = 0; i < anchors.length; ++i)
		{
			if (anchors[i].href.indexOf("artikel_id=")>=0)
			{
//				tab.reloadEveryEnabled = false;
//    		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    		gSound.play(sfile);
    		ticketsFound(tab, gSound, sfile, false);
    		
    		break;
			}
		}
	} 
}

function handleFrankfurt(tab, gSound, sfile)
{
	// Frage den Benutzer nach den gewnschten Spielen
	if (searchStrings.length == 0)
	{
		var searchLength = 0;
		while (!(searchLength>0))
		{
			searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
		}
		for (var i = 0; i < searchLength; ++i)
		{
			searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
		}
	}
	
	// Identifiziere die Tabelle mit den Spielen
	var tables = tab.contentDocument.getElementsByTagName("table");
	var table;
	for (var i = 0; i < tables.length; ++i)
	{
		if (tables[i].className.toLowerCase().indexOf("spielplan")>=0)
		{
			table = tables[i];
		}
	}
	
	// Suche alle Zeilen der Tabelle nach den gewnschten Spielen ab
	if (table != null)
	{
		for (var i = 2; i < table.rows.length; i+=3)
		{
			var breakFlag = false;
			for (var j = 0; j < searchStrings.length; ++j)
			{
				if (table.rows[i].innerHTML.toLowerCase().indexOf(searchStrings[j].toLowerCase())>=0)
				{
					// Wenn ein gewnschtes Spiel in der Tabelle gefunden wurde, berprfe, ob Tickets 
					// fr das Spiel verfgbar sind
					var rowBefore = table.rows[i-1];
					var availabilityCell = rowBefore.getElementsByTagName("td")[4];
					if (availabilityCell.className == "status order")
					{
//						tab.reloadEveryEnabled = false;
//    				document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    				gSound.play(sfile);
//						searchStrings = [];
    				ticketsFound(tab, gSound, sfile, true);
    				
    				breakFlag = true;
    				break;
					}
				}
			}
			if (breakFlag)
				break;
		}
	}
}

function handleEventimsports(tab, gSound, sfile)
{
	var mainFrame = tab.contentDocument.getElementsByTagName("frame")[0];
	var inputs = mainFrame.contentDocument.getElementsByTagName("input");
	
	// Finde heraus, ob zur Zeit berlast besteht
	var new_overload = false;
	var tables = mainFrame.contentDocument.getElementsByTagName("table");
  for (var i = 0; i < tables.length; ++i)
	{
		if (tables[i].innerHTML.indexOf("derzeit nicht erreichbar")>=0 ||
		    tables[i].innerHTML.indexOf("spteren Zeitpunkt")>=0)
		{
			new_overload = true;
			break;
		}
	}
	
	// Falls zuvor berlast bestand und jetzt nicht mehr, stoppe
	if (overload)
	{
		if (!new_overload) 
		{
			overload = false;
//			tab.reloadEveryEnabled = false;
//   		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//   		gSound.play(sfile);
   		ticketsFound(tab, gSound, sfile, false);
   	}
	}
  else
  {
  	// Falls zuvor keine berlast bestand, aber jetzt, dann aktiviere das Flag,
  	// sodass beim nchsten Durchlauf geprft wird, ob die berlast noch besteht
  	if (new_overload)
  	{
  		overload = true;
  	}
  	// wenn weder zuvor noch jetzt berlast besteht ...
  	else
  	{
  		// Hauptseite: Prfe, ob ein Bestellen-Button vorhanden
			if (mainFrame.contentDocument.getElementsByTagName("script").length == 1)
			{
				for (var i = 0; i < inputs.length; ++i) 
				{
					if (inputs[i].type.indexOf("submit")>=0 && inputs[i].value.indexOf("Bestellen")>=0) 
					{
//						tab.reloadEveryEnabled = false;
//    				document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    				gSound.play(sfile);
    				ticketsFound(tab, gSound, sfile, false);
    				
    				break;
					} 
				}
			}
			// Unterseite (Blockauswahl)
			else 
			{
				if (searchStrings.length == 0) 
				{
					var searchLength = 0;
					while (!(searchLength>0))
					{
						searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Bl"+ String.fromCharCode(246)+ "cke angeben"));
					}
					for (var i = 0; i < searchLength; ++i)
					{
						searchStrings[i] = window.prompt("Bitte " + (i+1) + "ten Block angeben");
					}
				}
		
				for (var i = 0; i < inputs.length; ++i) 
				{
					if (inputs[i].type.indexOf("submit")>=0)
					{
						for (var j = 0; j < searchStrings.length; ++j)
						{
							if (inputs[i].value.toLowerCase().indexOf(searchStrings[j].toLowerCase())>=0 && inputs[i].value.length == 2 + searchStrings[j].length) 
							{
								// Prfe, ob Anzahl Tickets > 0
								if (inputs[i].parentNode != null && inputs[i].parentNode.parentNode != null)
								{
									var tableElements = inputs[i].parentNode.parentNode.getElementsByTagName("td");
									var anzahl;
									for (var k = 0; k < tableElements.length; ++k)
									{
										if (tableElements[k].align == "right" && tableElements[k].className.indexOf("tablist")>=0)
										{
											anzahl = tableElements[k];
											break;
										}
									}
									if (anzahl != null && anzahl.innerHTML > 0)
									{
//										tab.reloadEveryEnabled = false;
//    								document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    								gSound.play(sfile);
//    								searchStrings = [];
    								ticketsFound(tab, gSound, sfile, true);
    								
    								break;
									}
								}
							} 
						}
					}
				}
		
			}
  	}
  } 
}

function handleEventim(tab, gSound, sfile)
{
	if(tab.contentDocument.getElementsByName("pk_id")[0] != null)
  {
//      tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);                       
  	ticketsFound(tab, gSound, sfile, false);
  }
  else if (tab.contentDocument.getElementById("warenkorb_tabtext") != null)
  {
//  		tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
  	ticketsFound(tab, gSound, sfile, false);
  }
	else if (tab.contentDocument.URL.toLowerCase().indexOf("fun=wk")>=0)
	{
		var inputs = tab.contentDocument.getElementsByTagName("input");
		for (var i = 0; i < inputs.length; ++i)
		{
			if (inputs[i].name.toLowerCase().indexOf("menge")>=0 && inputs[i].value>0)
			{
//				tab.reloadEveryEnabled = false;
//    		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    		gSound.play(sfile);
    		ticketsFound(tab, gSound, sfile, false);
    		
    		break;
			}
		}
	}
  else if (tab.contentDocument.getElementById("detaila_tabtext") != null)
  {
//  		tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
  	ticketsFound(tab, gSound, sfile, false);
  }
}

// fixed
function handleCottbus(tab, gSound, sfile)
{
	for (var i = 0; i < tab.contentDocument.links.length; ++i)
	{
		if (String(tab.contentDocument.links[i]).indexOf("packageReserve")>=0 ||
				String(tab.contentDocument.links[i]).indexOf("performance_id=")>=0)
		{
//			tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
    		ticketsFound(tab, gSound, sfile, false);
    	break;
		}
	}
}

function handleWolfsburg(tab, gSound, sfile)
{
	var tds = tab.contentDocument.getElementsByTagName("td");
	for (var i = 0; i < tds.length; ++i)
	{
		if (tds[i].className == "productListing-data" && tds[i].align == "center" &&
		    tds[i].childNodes[1] != null && tds[i].childNodes[1].innerHTML > 0)
		{
//			tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);	
    	ticketsFound(tab, gSound, sfile, false);
    	
    	break;		    	
		} 
	}
}

// old shop
function handleRostock(tab, gSound, sfile)
{
	for (var i = 0; i < tab.contentDocument.links.length; ++i)
	{
		if (String(tab.contentDocument.links[i]).indexOf("onlinebestell2_tk.php?spiel=")>=0)
		{
//			tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
    	ticketsFound(tab, gSound, sfile, false);
    	
    	break;	
		}
	}
}

// fixed
function handleTicketcorner(tab, gSound, sfile)
{
	var selects = tab.contentDocument.getElementsByTagName("select");
	for (var i = 0; i < selects.length; ++i)
	{
		if (selects[i].name != null && selects[i].name.indexOf("COUNT_")>=0)
		{
			if (selects[i].options.length >= 2)
			{
//				tab.reloadEveryEnabled = false;
//    		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    		gSound.play(sfile);
    		ticketsFound(tab, gSound, sfile, false);
    		
    		break;	
			}
		}
	}
}

function handleFreiburg(tab, gSound, sfile)
{
	var thisFrame = tab.contentDocument.getElementsByName("display")[0];
	if (thisFrame == null)
	{
		thisFrame = tab;
	}
	var anchors = thisFrame.contentDocument.getElementsByTagName("a");
	for (var i = 0; i < anchors.length; ++i)
	{
		if (anchors[i].href.indexOf("eventID=")>=0)
		{
//			tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
    	ticketsFound(tab, gSound, sfile, false);
    	
    	break;
		}
	}
}

function handleRupprecht(tab, gSound, sfile)
{
	if (searchStrings == null || searchStrings.length == 0)
	{
		var searchLength = 0;
		while (!(searchLength>0))
		{
			searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
		}
		for (var i = 0; i < searchLength; ++i)
		{
			searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
		}
	}
	
	var anchors = tab.contentDocument.getElementsByTagName("a");
	var breakflag = false;
	for (var i = 0; i < anchors.length; ++i)
	{
		if (anchors[i].className == "tickerLink")
			continue;
		for (var j = 0; j < searchStrings.length; ++j)
		{
			if (anchors[i].innerHTML.toLowerCase().indexOf(searchStrings[j].toLowerCase())>=0)
			{
//				tab.reloadEveryEnabled = false;
//    		document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    		gSound.play(sfile);
//				searchStrings = [];
    		ticketsFound(tab, gSound, sfile, true);
    		
    		breakflag = true;
    		break;
			}
		}
		if (breakflag)
			break;
	}
}

function handleKrause(tab, gSound, sfile)
{
	if (searchStrings.length == 0)
	{
		var searchLength = 0;
		while (!(searchLength>0))
		{
			searchLength = parseFloat(window.prompt("Bitte Anzahl der gew" + String.fromCharCode(252) +"nschten Spiele angeben"));
		}
		for (var i = 0; i < searchLength; ++i)
		{
			searchStrings[i] = window.prompt("Bitte " + (i+1) + "tes Spiel angeben");
		}
	}
	
	// Search the frame (it is very well hidden ;) )
	var frame1 = tab.contentDocument.getElementsByName("inhalt")[0];
	if (frame1 != null)
	{
		var frame2 = frame1.contentDocument.getElementsByName("main")[0];
		if (frame2 != null)
		{
			var frame3 = frame2.contentDocument.getElementsByName("inhalt")[0];
			if (frame3 != null)
			{
				var doc = frame3.contentDocument;
				for (var i = 0; i < searchStrings.length; ++i)
				{
					if (doc.body.innerHTML.toLowerCase().indexOf(searchStrings[i].toLowerCase())>=0)
					{
//						tab.reloadEveryEnabled = false;
//    				document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    				gSound.play(sfile);
//    				searchStrings = [];
    				ticketsFound(tab, gSound, sfile, true);
    				
    				break;
					}
				}
			}
		}
	}
}

function handleChelsea(tab, gSound, sfile)
{
	if (tab.contentDocument.getElementsByName("mytkts_user_name")[0]!=null &&
	    tab.contentDocument.getElementsByName("mytkts_user_name")[0].className == "loginfields")
	{
//		tab.reloadEveryEnabled = false;
//    document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    gSound.play(sfile);
		ticketsFound(tab, gSound, sfile, false);
	}
}

function handleFrance08(tab, gSound, sfile)
{
	if (searchStrings.length == 0)
	{
		var searchLength = 0;
		while (!(searchLength>0))
		{
			searchLength = parseFloat(window.prompt("Es gibt 3 Kategorien (1, 2, 3). Nach wie vielen Kategorien soll gesucht werden?"));
		}
		for (var i = 0; i < searchLength; ++i)
		{
			searchStrings[i] = window.prompt("Bitte " + (i+1) + "te Kategorie angeben, nach der gesucht werden soll (1, 2 oder 3)");
		}
	}
	
	for (var i = 0; i < searchStrings.length; ++i)
	{
		if (tab.contentDocument.body.innerHTML.indexOf("gorie "+ searchStrings[i]+"<br>")>=0)
		{
//			tab.reloadEveryEnabled = false;
//    	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
//    	gSound.play(sfile);
//    	searchStrings = [];
    	ticketsFound(tab, gSound, sfile, true);
    	
    	break;
		}
	}
}

function handleWM2006(tab, gSound, sfile, sfileSec)
{
	// WM 2006: Login
  if(tab.contentDocument.getElementById("benutzernamekunde") != null)
  {
  	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
  	gSound.play(sfile);                         
  	return;
  }
  
  // WM 2006: Resale package
  if(tab.contentDocument.getElementsByName("menge")[1] != null)
  {
  	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
  	gSound.play(sfile);                                              
  	return;
  }
  
  // WM 2006: Splash screen
  if(tab.contentDocument.getElementsByName("06")[0] != null)
  {
  	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
  	gSound.play(sfileSec);
  	return;
  }
}

function handleItaly08(tab, gSound, sfile, sfileSec)
{
	// Italy08 tickets available
  if (tab.contentDocument.body.innerHTML.indexOf("Acquista ORA!")>=0)
  {
  	document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
  	ticketsFound(tab, gSound, sfile, true);                        
  	return;
  }
  
  
}

function colorTab(tab)
{
  var mytab = gBrowser.mTabs[gBrowser.getBrowserIndexForDocument(tab.contentDocument)];
	var nodes = document.getAnonymousNodes (mytab);
	var i = 0;
	for (i = nodes.length - 1; i >= 0; i--) {
	  if(tab.currentState == 1) { 
	     nodes[i].style.setProperty ('background-color', 'rgb(0, 255, 51)', '');
	     }
	  if(tab.currentState == 0) { 
	     nodes[i].style.setProperty ('background-color', 'rgb(255, 255, 51)', '');
	     }
	  if(tab.currentState == -1) { 
	     nodes[i].style.removeProperty ('background-color');
	     }
  }   
}

function ticketsFound(tab, gSound, sfile, b)
{
	tab.currentState = 1;      
  colorTab(tab);
  tab.currentState = -1;
	tab.reloadEveryEnabled = false;
  document.getElementById("but_reloadevery_enable").setAttribute("checked", "false");
  gSound.play(sfile);
  if (b)
  	searchStrings = [];
}
